package com.hero.objects.powers;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.ui.dialog.DamageResistanceDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.XMLUtility;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class DamageResistance extends Power {

	private static String xmlID = "DAMAGERESISTANCE";

	private int pdLevels;

	private int edLevels;

	private int mdLevels;

	private int fdLevels;

	private int powdLevels;

	public DamageResistance(Element root) {
		super(root, DamageResistance.xmlID);
	}

	@Override
	public String getColumn2Output() {
		String ret = getAlias() + " " + getDamageDisplay();
		if (getName().trim().length() > 0) {
			ret = "<i>" + getName() + ":</i>  " + ret;
		}
		ret += "(";
		if (pdLevels > 0) {
			ret += pdLevels + " PD";
		}
		if (edLevels > 0) {
			if (pdLevels > 0) {
				ret += "/";
			}
			ret += edLevels + " ED";
		}
		if (mdLevels > 0) {
			if ((pdLevels > 0) || (edLevels > 0)) {
				ret += "/";
			}
			ret += mdLevels + " Mental Def.";
		}
		if (fdLevels > 0) {
			if ((pdLevels > 0) || (edLevels > 0) || (mdLevels > 0)) {
				ret += "/";
			}
			ret += fdLevels + " Flash Def.";
		}
		if (powdLevels > 0) {
			if ((pdLevels > 0) || (edLevels > 0) || (mdLevels > 0)
					|| (fdLevels > 0)) {
				ret += "/";
			}
			ret += powdLevels + " Power Def.";
		}
		ret += ")";
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			ret += ":  " + getInput();
		}
		if (getSelectedOption() != null) {
			ret += " (";
			ret += getSelectedOption().getAlias();

			String adderString = getAdderString();
			if (adderString.trim().length() > 0) {
				ret += "; " + adderString;
			}
			ret += ")";
		} else {
			String adderString = getAdderString();
			if (adderString.trim().length() > 0) {
				ret += " (" + adderString + ")";
			}
		}
		ret += getModifierString();
		if ((getEndUsage() > 0)
				&& (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") != null)
				&& (GenericObject.findObjectByID(getAllAssignedModifiers(),
						"ENDRESERVEOREND") == null)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			if (getUseENDReserve()) {
				ret += " (uses END Reserve)";
			} else {
				ret += " (uses Personal END)";
			}
		}
		return ret;
	}

	@Override
	public String getDamageDisplay() {
		String ret = "";
		return ret;
	}

	@Override
	public GenericDialog getDialog(boolean isNew, boolean isPower) {
		return new DamageResistanceDialog(this, isNew, isPower);
	}

	public int getEdLevels() {
		return edLevels;
	}

	public int getFdLevels() {
		return fdLevels;
	}

	@Override
	public int getLevels() {
		return pdLevels + edLevels + mdLevels + fdLevels + powdLevels;
	}

	@Override
	public int getMdLevels() {
		return mdLevels;
	}

	public int getPdLevels() {
		return pdLevels;
	}

	public int getPowdLevels() {
		return powdLevels;
	}

	@Override
	public Element getSaveXML() {
		Element root = super.getSaveXML();
		root.setAttribute("PDLEVELS", "" + pdLevels);
		root.setAttribute("EDLEVELS", "" + edLevels);
		root.setAttribute("MDLEVELS", "" + mdLevels);
		root.setAttribute("FDLEVELS", "" + fdLevels);
		root.setAttribute("POWDLEVELS", "" + powdLevels);
		return root;
	}

	@Override
	public void restoreFromSave(Element root) {
		super.restoreFromSave(root);
		String check = XMLUtility.getValue(root, "PDLEVELS");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				pdLevels = Integer.parseInt(check);
			} catch (NumberFormatException ex) {
			}
		}
		check = XMLUtility.getValue(root, "EDLEVELS");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				edLevels = Integer.parseInt(check);
			} catch (NumberFormatException ex) {
			}
		}
		check = XMLUtility.getValue(root, "MDLEVELS");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				mdLevels = Integer.parseInt(check);
			} catch (NumberFormatException ex) {
			}
		}
		check = XMLUtility.getValue(root, "FDLEVELS");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				fdLevels = Integer.parseInt(check);
			} catch (NumberFormatException ex) {
			}
		}
		check = XMLUtility.getValue(root, "POWDLEVELS");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				powdLevels = Integer.parseInt(check);
			} catch (NumberFormatException ex) {
			}
		}
		setLevels(pdLevels + edLevels + mdLevels + fdLevels + powdLevels);
	}

	public void setEdLevels(int edLevels) {
		this.edLevels = edLevels;
		setLevels(pdLevels + edLevels + mdLevels + fdLevels + powdLevels);
	}

	public void setFdLevels(int fdLevels) {
		this.fdLevels = fdLevels;
		setLevels(pdLevels + edLevels + mdLevels + fdLevels + powdLevels);
	}

	public void setMdLevels(int mdLevels) {
		this.mdLevels = mdLevels;
		setLevels(pdLevels + edLevels + mdLevels + fdLevels + powdLevels);
	}

	public void setPdLevels(int pdLevels) {
		this.pdLevels = pdLevels;
		setLevels(pdLevels + edLevels + mdLevels + fdLevels + powdLevels);
	}

	public void setPowdLevels(int powdLevels) {
		this.powdLevels = powdLevels;
		setLevels(pdLevels + edLevels + mdLevels + fdLevels + powdLevels);
	}
}